/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.SVNChangeEntry;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLogParser {
    String repo = "";
    String changes = "";

    public SVNLogParser(String repo) {
        this.repo = repo;
    }

    public Map<String, String> parseSVNCommitData(String revisionID) throws Exception {
        HashMap<String, String> parsedData = new HashMap<String, String>();
        Object url = null;
        BasicAuthenticationManager authManager = new BasicAuthenticationManager("svn.username", "svn.simple");
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(true);
        String[] paths = new String[]{""};
        SVNRevision revision = SVNRevision.create(Long.valueOf(revisionID));
        ISVNChangeEntryHandler myhandles = new ISVNChangeEntryHandler(){

            @Override
            public void handleEntry(SVNChangeEntry entry) throws SVNException {
                SVNLogParser.this.changes = SVNLogParser.this.changes + entry.getType() + " " + entry.getPath();
                SVNLogParser.this.changes = SVNLogParser.this.changes + "(;filechange;)";
            }
        };
        File repoServer = new File(this.repo);
        SVNLookClient client = new SVNLookClient(authManager, (ISVNOptions)options);
        client.doGetChanged(repoServer, revision, myhandles, true);
        parsedData.put("Revision", revisionID);
        parsedData.put("Author", client.doGetAuthor(repoServer, revision));
        parsedData.put("Date", client.doGetDate(repoServer, revision).toString());
        parsedData.put("Message", client.doGetLog(repoServer, revision));
        parsedData.put("Changes", this.changes);
        return parsedData;
    }
}

